#include <cstdlib>
#include <iostream>
#include <string>
#include <thread>
#include <mutex>

using namespace std;


/*
 * TODO: Use the debugger to display the following outputs.
 * 
 * Output 1:
 * Alphonse dit : "je salue mon ami Gaston"
 * Gaston dit : "mon ami Alphonse m'a salué et je le salue en retour"
 * Gaston dit : "je salue mon ami Alphonse"
 * Alphonse dit : "mon ami Gaston m'a salué et je le salue en retour"
 *
 * Output 2:
 * Alphonse dit : "je salue mon ami Gaston"
 * Gaston dit : "je salue mon ami Alphonse"
 */


class ami {
private:
  string _nom;
  mutex _mutex;

public:
  ami(string nom) : _nom(nom) { }

  void saluer(ami & ami) {
    _mutex.lock();
    cout << "\"" << _nom << " dit : je salue mon ami " << ami._nom << "\"" << endl;
    ami.repondre(*this);
    _mutex.unlock();
  }

  void repondre(ami & ami) {
    _mutex.lock();
    cout << "\"" << _nom << " dit : mon ami " << ami._nom << " m'a salué et je le salue en retour\"" << endl;
    _mutex.unlock();
  }

};

int main(int argc, char** argv) {
  ami alphonse("Alphonse");
  ami gaston("Gaston");

  thread al([&alphonse, &gaston]() { // Thread started with a lambda expression 
    alphonse.saluer(gaston);
  });

  thread ga([&alphonse, &gaston]() {
    gaston.saluer(alphonse);
  });

  al.join();
  ga.join();
  return EXIT_SUCCESS;
}
