#pragma once
#include <thread>

#include "dinnerTable.hpp"

class AbstractPhilosopher {
private:
  volatile bool interrupted = false;
  int iterations = 0;
  thread t;
  void run();

protected:
  DinnerTable* table;
  int philosopherId;

public:

  AbstractPhilosopher(DinnerTable* table, int philosopherId);
  void interrupt();
  int timesEaten();

  virtual void startEat() = 0;
  virtual void startThink() = 0;

  friend std::ostream& operator<<(std::ostream&, const AbstractPhilosopher&);
};
