#pragma once

#include <vector>
#include <mutex>

class DinnerTable {

private:
  int nbPhilosophers;
  mutex** locks;
  int* takenBy;

  void takeStick(int philosopherId, int fork);
  void dropStick(int philosopherId, int fork);

public:
  DinnerTable(int nbPhilosophers);
  ~DinnerTable();
  int numberOfGuests();
  int nbSticks(int philosopherId);
  void takeLeftStick(int philosopherId);
  void takeRightStick(int philosopherId);
  void dropLeftStick(int philosopherId);
  void dropRightStick(int philosopherId);
};
