#pragma once

#include "abstractPhilosopher.hpp"
#include "dinnerTable.hpp"

class StarvingPhilosopher : public AbstractPhilosopher {

public:
  StarvingPhilosopher(DinnerTable* table, int philosopherId) :
    AbstractPhilosopher(table, philosopherId) {}
	
  void startEat() {
    table->takeLeftStick(philosopherId);
    table->takeRightStick(philosopherId);
  }

  void startThink() {
    table->dropLeftStick(philosopherId);
    table->dropRightStick(philosopherId);
  }
	
};
