#pragma once

#include <mutex>
#include <condition_variable>

#include "bathroom.hpp"

using namespace std;

class DeadlockFreeBathroom : public Bathroom {

private:
  int nbPlaces;
  int counters[2] = {0,0}; // {number of men inside; number of women inside}
  mutex _mutex;
  condition_variable cv;  

public:
  DeadlockFreeBathroom(int nbBathroom) {
    nbPlaces = nbBathroom;
  }
  
  void enter(person* p) {
    unique_lock<mutex> lck(_mutex);
    int sex = (p->isMale() ? 0 : 1);
    while(counters[sex] > nbPlaces || counters[1-sex] > 0 )
      cv.wait(lck);
    counters[sex]++;
  }
  
  void leave(person* p) {
    unique_lock<mutex> lck(_mutex);
    counters[(p->isMale()?0:1)]--;
    cv.notify_all();
  }
};
