#include <cstdlib>
#include <iostream>
#include <thread>
#include <vector>
#include <ctime>

using namespace std;

#include "person.hpp"
#include "bathroom.hpp"
#include "nonParallelBathroom.hpp"
#include "deadlockFreeBathroom.hpp"
#include "starvationFreeBathroom.hpp"
  

// Main program
int main(int argc, char** argv) {

  // Parameters
  int n = 20;
  int iterations = 10;
  int nbBathroom = 5;

  // TODO : Replace the basic bathroom by a deadlock-free (then starvation-free) one.
  //  Bathroom* bathroom = new NonParallelBathroom(nbBathroom);
  //  Bathroom* bathroom = new DeadlockFreeBathroom(nbBathroom);
  Bathroom* bathroom = new StarvationFreeBathroom(nbBathroom);
  //////////////////////////////////////////////////////////////////////////////////

  srand(time(nullptr));
  vector<person*> people(n);
  
  for(int i = 0 ; i < n ; ++i ) {
    people[i] = new person(i, rand()%2, bathroom, iterations);
  }

  this_thread::sleep_for(chrono::milliseconds(5000));

  for(person* p: people){
    p->join();
  }
    
  return EXIT_SUCCESS;
}


// Implementation of class person
void person::run() {
  for(int i = 1; i<=nbEntries; i++) {
    bathroom->enter(this);
    cout << *this << " entered the bathroom " << i << " times" << endl;
    this_thread::sleep_for(chrono::milliseconds(100));
    cout << *this << " leaved the bathroom " << i << " times" << endl;
    bathroom->leave(this);
    this_thread::sleep_for(chrono::milliseconds(100));
  }
}

person::person(int _id, bool is_male, Bathroom* _bathroom, int iterations) {
  id = _id;
  male = is_male;
  bathroom = _bathroom;
  nbEntries = iterations;
  t = thread(&person::run, this);
}

void person::join() {
  t.join();
}

bool person::isMale() {
  return male;
}

ostream& operator<<(ostream &strm, const person &p) {
  if (p.male) {
    return strm << "male   " << p.id;
  } else {
    return strm << "female " << p.id;
  }
}
