#include <cstdlib>
#include <iostream>
#include <mutex>
#include <condition_variable>

using namespace std;

/**
 * Do not try to understand the code of class NonReentrantLock yet!
 */
class NonReentrantLock {
public:
  inline void lock() {
    unique_lock<mutex> lk(mtx);
    while(taken) cv.wait(lk);
    taken = true;
  }

  inline void unlock() {
    unique_lock<mutex> lk(mtx);
    taken = false;
    cv.notify_one();
  }
private:
  mutex mtx;
  condition_variable cv;
  bool taken = false;
};



// TODO : Invert comments on the next lines
//mutex _mutex;
NonReentrantLock _mutex;

int factorielle (int n) {
  int result;
  _mutex.lock();
  if(n == 0) 
    result = 1;
  else {
    result = factorielle(n-1)*n;
  }
  _mutex.unlock();
  return result;
}

// Main program
int main(int argc, char** argv) {
  cout << factorielle(5) << endl;
  return EXIT_SUCCESS;
}
