// Inspired from https://github.com/thibaultdelor/InvalidCodeBlog

// Compile with optimization option -O1 or more


#include <cstdlib>
#include <iostream>
#include <vector>
#include <thread>

using namespace std;

// Main program
int main(int argc, char** argv) {

  //TODO: comment/uncomment the following lines: 
  volatile int value = 0;
  //int value = 0;
  
  thread reader([&value]() {
      int local_value = value;
      while (local_value < 5) {
	if (local_value != value) {
	  cout << "Read value: " << value << endl;
	  local_value = value;
	}
      }
    });
  
  thread writer([&value]() {
      int local_value = value;
      while (local_value < 5) {
	cout << "Write value to " << local_value + 1 << endl;
	value = ++local_value;
	this_thread::sleep_for(chrono::milliseconds(500));
      }
    });

  reader.join();
  writer.join();
  
  return EXIT_SUCCESS;
}
