#include <cstdlib>
#include <iostream>
#include <thread>
#include <vector>
#include <ctime>

using namespace std;

#include "philosopher.hpp"
#include "abstractPhilosopher.hpp"
#include "starvingPhilosopher.hpp"
#include "dinnerTable.hpp"


int main(int argc, char** argv) {	

  int n = 5;
  DinnerTable* table = new DinnerTable(n);

  // Start the threads
  vector<AbstractPhilosopher*> philosophers(n);

  for (int i = 0; i < n; i++) {
    // TODO : Replace starving philosophers by smart ones !
    //    philosophers[i] = new StarvingPhilosopher(table, i);
    philosophers[i] = new Philosopher(table, i);
    //////////////////////////////////////////////////////
  }

  // Run the simulation for 5s
  this_thread::sleep_for(chrono::milliseconds(5000));

  for(AbstractPhilosopher* p: philosophers){
    p->interrupt();
  }
  cout << endl;
  for(AbstractPhilosopher* p: philosophers){
    cout << *p << " ate " << p->timesEaten() <<  " times" << endl;
  }
		
}








/***************************************
Implementation of AbstractPhilosopher
****************************************/

AbstractPhilosopher::AbstractPhilosopher(DinnerTable* table, int philosopherId) {
  this->philosopherId = philosopherId;
  this->table = table;
  t = thread(&AbstractPhilosopher::run, this);
}

int AbstractPhilosopher::timesEaten() {
  return iterations;
}

void AbstractPhilosopher::interrupt() {
  interrupted = true;
  t.join();
}

void AbstractPhilosopher::run() {
  while (!interrupted) {
    startEat();

    if(table->nbSticks(philosopherId) == 0) {
      cout << *this << " tried to eat without sticks and died of suffocation" << endl;
      return;
    }
    if(table->nbSticks(philosopherId) == 1) {
      cout << *this << " tried to eat with only one fork, broke it and then died" << endl;
      return;
    }
    iterations++;
    cout << *this << " is Eating for the " << iterations << "th time" << endl;

    this_thread::sleep_for(chrono::milliseconds(100));

    startThink();
    this_thread::sleep_for(chrono::milliseconds(100));
  }
}


ostream& operator<<(ostream &strm, const AbstractPhilosopher &p) {
  return strm << "philosopher " << p.philosopherId;
}










/***************************************
Implementation of DinnerTable
****************************************/

// No synchronization needed, as takenBy[philosopherId] is write-protected by locks[philosopherId]
void DinnerTable::takeStick(int philosopherId, int fork) {
  locks[fork]->lock();
  takenBy[fork] = philosopherId;
  // Taking a fork takes some time...
  this_thread::sleep_for(chrono::milliseconds(5));
}
void DinnerTable::dropStick(int philosopherId, int fork) {
  if(takenBy[fork] == philosopherId) {
    takenBy[fork] = -1;
    locks[fork]->unlock();
  }
}

DinnerTable::DinnerTable(int nbPhilosophers) {
  this->nbPhilosophers = nbPhilosophers;
  takenBy = new int[nbPhilosophers];
  locks = new mutex*[nbPhilosophers];
  for(int i = 0; i<nbPhilosophers; i++) {
    takenBy[i] = -1;
    locks[i] = new mutex();
  }
}

DinnerTable::~DinnerTable() {
  for(int i = 0; i<nbPhilosophers; i++) {
    delete locks[i];
  }
  delete locks;
  delete takenBy;
}

int DinnerTable::numberOfGuests() {
  return nbPhilosophers;
}
  
int DinnerTable::nbSticks(int philosopherId) {
  int result = 0;
  if(takenBy[philosopherId] == philosopherId)
    result++;
  if(takenBy[(philosopherId+1)%nbPhilosophers] == philosopherId)
    result++;
  return result;
}
	
void DinnerTable::takeLeftStick(int philosopherId) {
  cout << "philosopher " << philosopherId << " wants left fork" << endl;
  takeStick(philosopherId, philosopherId);
  cout << "philosopher " << philosopherId << " has left fork" << endl;
}
	
void DinnerTable::takeRightStick(int philosopherId) {
  cout << "philosopher " << philosopherId << " wants right fork" << endl;
  takeStick(philosopherId, (philosopherId+1)%nbPhilosophers);
  cout << "philosopher " << philosopherId << " has right fork" << endl;
}
	
void DinnerTable::dropLeftStick(int philosopherId) {
  cout << "philosopher " << philosopherId << " drops left fork" << endl;
  dropStick(philosopherId, philosopherId);
}
	
void DinnerTable::dropRightStick(int philosopherId) {
  cout << "philosopher " << philosopherId << " drops right fork" << endl;
  dropStick(philosopherId, (philosopherId+1)%nbPhilosophers);
}
