#pragma once

#include "abstractPhilosopher.hpp"
#include "dinnerTable.hpp"

class Philosopher : public AbstractPhilosopher {

public:
  Philosopher(DinnerTable* table, int philosopherId) :
    AbstractPhilosopher(table, philosopherId) {}
	
  void startEat() {
    if(philosopherId == 0) {
      table->takeRightStick(philosopherId);
      table->takeLeftStick(philosopherId);
    } else {
      table->takeLeftStick(philosopherId);
      table->takeRightStick(philosopherId);
    }
  }

  void startThink() {
    table->dropLeftStick(philosopherId);
    table->dropRightStick(philosopherId);
  }
	
};
