#pragma once

#include <mutex>
#include <condition_variable>
#include <queue>

#include "bathroom.hpp"



class StarvationFreeBathroom : public Bathroom {

 private:
  int nbPlaces;
  int counters[2] = {0,0}; // {number of men inside; number of women inside}

  queue<person*> q;
  
  mutex _mutex;
  condition_variable cv;
  
 public:
  StarvationFreeBathroom(int nbBathroom) {
    nbPlaces = nbBathroom;
  }
  
  void enter(person* p) {
    unique_lock<mutex> lck(_mutex);
    int sex = (p->isMale()?0:1);
    q.push(p);
    while(q.front() != p || counters[sex] > nbPlaces || counters[1-sex] > 0)
      cv.wait(lck);
    counters[sex]++;
    q.pop();
  }
  
  void leave(person* p) {
    unique_lock<mutex> lck(_mutex);
    counters[(p->isMale()?0:1)]--;
    cv.notify_all();
  }
};

